﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// GH 资源服务
    /// </summary>
    public interface IGHResourceService
    {
        /// <summary>
        /// 获取GH资源文件夹
        /// </summary>
        /// <param name="url">GH请求地址</param>
        /// <returns>GH资源树根节点</returns>
        List<GHResourceFolderModel> GetGHResourceFolders(string url);

        /// <summary>
        /// 获取GH资源文件
        /// </summary>
        /// <param name="url">GH请求地址</param>
        /// <returns>GH资源文件</returns>
        List<GHResourceFileModel> GetGHResourceFiles(string url);
    }
}
