﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// 节目服务
    /// </summary>
    public class ProgramService : IProgramService
    {
        /// <summary>
        /// 节目服务锁
        /// </summary>
        public static object lock_object = new object();

        /// <summary>
        /// 加载节目模板集合
        /// </summary>
        /// <returns>节目模板集合</returns>
        public ObservableCollection<ProgramTemplateModel> LoadProgramTemplateModels()
        {
            List<ProgramTemplateModel> list = new List<ProgramTemplateModel>();

            foreach (var entity in ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramTemplate.FindAll())
            {
                ProgramTemplateModel model = new ProgramTemplateModel(entity);
                model.PropertyFromEntity();

                list.Add(model);
            }

            return list.OrderBy(p => p.OrderIndex).ToObservableCollection();
        }

        /// <summary>
        /// 保存节目模板集合
        /// </summary>
        /// <param name="models">节目模板集合</param>
        public void SaveProgramTemplateModels(IList<ProgramTemplateModel> models)
        {
            lock (lock_object)
            {
                List<ProgramTemplateEntity> list = new List<ProgramTemplateEntity>();
                for (int i = 0; i < models.Count; i++)
                {
                    ProgramTemplateModel model = models[i];
                    model.OrderIndex = i;
                    model.PropertyToEntity();
                    list.Add(model.Entity);
                }

                ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramTemplate.DeleteAll();
                ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramTemplate.Insert(list);
            }
        }

        /// <summary>
        /// 加载节目单集合
        /// </summary>
        /// <returns>节目单集合</returns>
        public ObservableCollection<ProgramListModel> LoadProgramListModels()
        {
            List<ProgramListModel> list = new List<ProgramListModel>();

            foreach (var entity in ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramList.FindAll())
            {
                ProgramListModel model = new ProgramListModel(entity);
                model.PropertyFromEntity();

                list.Add(model);
            }

            Dictionary<string, ProgramListModel> dic = list.ToDictionary(p => p.ListID, p => p);

            foreach (var entity in ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramListItem.FindAll())
            {
                ProgramListItemModel model = new ProgramListItemModel(entity);
                model.PropertyFromEntity();

                if (!dic.TryGetValue(model.ListID, out ProgramListModel owner))
                    continue;

                model.ProgramListModel = owner;
                owner.Items.Add(model);
            }

            foreach (var model in list)
            {
                model.Items = model.Items.OrderBy(p => p.OrderIndex).ToObservableCollection();
            }

            return list.OrderBy(p => p.OrderIndex).ToObservableCollection();
        }

        /// <summary>
        /// 保存节目单模型集合
        /// </summary>
        /// <param name="models">节目单模型集合</param>
        public void SaveProgramListModels(IList<ProgramListModel> models)
        {
            lock (lock_object)
            {
                List<ProgramListEntity> listEntitys = new List<ProgramListEntity>();
                List<ProgramListItemEntity> listItemEntitys = new List<ProgramListItemEntity>();

                for (int i = 0; i < models.Count; i++)
                {
                    ProgramListModel listModel = models[i];
                    listModel.OrderIndex = i;
                    listModel.PropertyToEntity();
                    listEntitys.Add(listModel.Entity);

                    for (int j = 0; j < listModel.Items.Count; j++)
                    {
                        ProgramListItemModel listItemModel = listModel.Items[j];
                        listItemModel.OrderIndex = j;
                        listItemModel.PropertyToEntity();
                        listItemEntitys.Add(listItemModel.Entity);
                    }
                }

                ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramListItem.DeleteAll();
                ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramList.DeleteAll();
                ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramListItem.Insert(listItemEntitys);
                ApplicationDomainEx.CurrentProjectDomain.ProjectContext.ProgramList.Insert(listEntitys);
            }
        }
    }
}
