﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// 界面模板
    /// </summary>
    public class ProgramTemplateEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [LiteDB.BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 模板ID
        /// </summary>
        public string TemplateID { get; set; } = Guid.NewGuid().ToString();

        /// <summary>
        /// 模板类型
        /// </summary>
        public ProgramTemplateType TemplateType { get; set; }

        /// <summary>
        /// 场景名
        /// </summary>
        public string SceneName { get; set; }

        /// <summary>
        /// 缩略图
        /// </summary>
        public string Thumbnail { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 层
        /// </summary>
        public string Layer { get; set; }

        /// <summary>
        /// 引擎类型
        /// </summary>
        public TVPEngineType EngineType { get; set; }

        /// <summary>
        /// 排序索引
        /// </summary>
        public int OrderIndex { get; set; }
    }
}
