﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// GH Feed 节点
    /// </summary>
    public class GH_Feed_Node : IXmlSerialize
    {
        /// <summary>
        /// 编号
        /// </summary>
        public string id { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public string updated { get; set; }

        /// <summary>
        /// 作者
        /// </summary>
        public GH_Author_Node author { get; set; } = new GH_Author_Node();

        /// <summary>
        /// 引用连接集合
        /// </summary>
        public List<GH_Link_Node> links { get; set; } = new List<GH_Link_Node>();

        /// <summary>
        /// 节点集合
        /// </summary>
        public List<GH_Entry_Node> entries { get; set; } = new List<GH_Entry_Node>();

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            if (element == null)
                return;

            this.id = element.Element(XName.Get("id", GH_Xmlns_Enums.xmlns))?.Value;
            this.title = element.Element(XName.Get("title", GH_Xmlns_Enums.xmlns))?.Value;
            this.updated = element.Element(XName.Get("updated", GH_Xmlns_Enums.xmlns))?.Value;
            this.author.FromXmlElement(element.Element(XName.Get("author", GH_Xmlns_Enums.xmlns)));
            foreach (XElement link in element.Elements(XName.Get("link", GH_Xmlns_Enums.xmlns)))
            {
                GH_Link_Node link_node = new GH_Link_Node();
                link_node.FromXmlElement(link);

                this.links.Add(link_node);
            }

            foreach (XElement entry in element.Elements(XName.Get("entry", GH_Xmlns_Enums.xmlns)))
            {
                GH_Entry_Node entry_Node = new GH_Entry_Node();
                entry_Node.FromXmlElement(entry);

                this.entries.Add(entry_Node);
            }
        }
    }
}
