﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Plugin;
using VIZ.TVP.Domain;
using VIZ.TVP.Plugin;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// Control List 插件生命周期
    /// </summary>
    public class ControlListPluginLifeCycle : IPluginLifeCycle
    {
        /// <summary>
        /// 插件ID
        /// </summary>
        /// <remarks>
        /// 插件ID不能包含点号
        /// </remarks>
        public const string PLUGIN_ID = PluginIDs.CONTROL_LIST;

        /// <summary>
        /// 插件显示名称
        /// </summary>
        public const string PLUGIN_DISPLAY_NAME = "Control List";

        /// <summary>
        /// 注册
        /// </summary>
        /// <returns>插件信息</returns>
        public PluginInfo Register()
        {
            PluginInfo info = new PluginInfo();
            info.ID = PLUGIN_ID;
            info.DisplayName = PLUGIN_DISPLAY_NAME;
            info.HasView = true;
            info.HasSettingView = false;
            info.ViewInfo = new PluginViewInfo(typeof(ControlListView), typeof(ControlListViewModel));

            return info;
        }

        /// <summary>
        /// 初始化
        /// </summary>
        public void Initialize()
        {

        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {

        }

    }
}
