﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows;
using VIZ.TVP.Storage;
using VIZ.TVP.Domain;
using System.Windows.Forms;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 控制列表值数据模板选择器
    /// </summary>
    public class ControlListValueDataTemplateSelecter : DataTemplateSelector
    {
        /// <summary>
        /// 文本模板
        /// </summary>
        public DataTemplate TextDataTemplate { get; set; }

        /// <summary>
        /// 图片模板
        /// </summary>
        public DataTemplate ImageDataTemplate { get; set; }

        /// <summary>
        /// Bool类型的模板
        /// </summary>
        public DataTemplate BooleanDataTemplate { get; set; }

        /// <summary>
        /// 三元组
        /// </summary>
        public DataTemplate TripletDataTemplate { get; set; }

        /// <summary>
        /// 筛选模板
        /// </summary>
        /// <param name="item">项</param>
        /// <param name="container">容器</param>
        /// <returns>数据模板</returns>
        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            GridCellData data = (GridCellData)item;

            VizControlObjectFieldModel model = data.RowData.Row as VizControlObjectFieldModel;
            if (model == null)
                return null;

            switch (model.Type)
            {
                case VizControlObjectFieldType.none: return null;
                case VizControlObjectFieldType.text: return this.TextDataTemplate;
                case VizControlObjectFieldType.boolean: return this.BooleanDataTemplate;
                case VizControlObjectFieldType.richtext: return this.TextDataTemplate;
                case VizControlObjectFieldType.image: return this.ImageDataTemplate;
                case VizControlObjectFieldType.list: return this.TextDataTemplate;
                case VizControlObjectFieldType.triplet: return this.TripletDataTemplate;
                default: return null;
            }
        }
    }
}
