﻿using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// 创建项目视图模型
    /// </summary>
    public class CreateProjectViewModel : ViewModelBase
    {
        public CreateProjectViewModel()
        {
            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.EnterCommand = new VCommand(this.Enter);
            this.CancelCommand = new VCommand(this.Cancel);
            this.SelectFolderCommand = new VCommand(this.SelectFolder);
        }

        // ----------------------------------------------------------------------
        // Property
        // ----------------------------------------------------------------------

        #region IsEnter -- 是否确定

        private bool isEnter;
        /// <summary>
        /// 是否确定
        /// </summary>
        public bool IsEnter
        {
            get { return isEnter; }
            set { isEnter = value; this.RaisePropertyChanged(nameof(IsEnter)); }
        }

        #endregion

        #region ProjectName -- 项目名

        private string projectName;
        /// <summary>
        /// 项目名
        /// </summary>
        public string ProjectName
        {
            get { return projectName; }
            set { projectName = value; this.RaisePropertyChanged(nameof(ProjectName)); }
        }

        #endregion

        #region ProjectPath -- 项目路径

        private string projectPath;
        /// <summary>
        /// 项目路径
        /// </summary>
        public string ProjectPath
        {
            get { return projectPath; }
            set { projectPath = value; this.RaisePropertyChanged(nameof(ProjectPath)); }
        }

        #endregion

        // ----------------------------------------------------------------------
        // Command
        // ----------------------------------------------------------------------

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            this.ProjectPath = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "projects");
        }

        #endregion

        #region EnterCommand -- 确定命令

        /// <summary>
        /// 确定命令
        /// </summary>
        public VCommand EnterCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            if (string.IsNullOrWhiteSpace(this.ProjectName))
            {
                DXMessageBox.Show("请输入项目名");
                return;
            }

            if (string.IsNullOrWhiteSpace(this.ProjectPath))
            {
                DXMessageBox.Show("请选择项目所在文件夹");
                return;
            }

            string path = System.IO.Path.Combine(this.ProjectPath, this.ProjectName);
            if (System.IO.File.Exists(path))
            {
                DXMessageBox.Show("项目已经存在");
                return;
            }

            this.IsEnter = true;
            this.GetWindow()?.Close();
        }

        #endregion

        #region CancelCommand -- 取消命令

        /// <summary>
        /// 取消命令
        /// </summary>
        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            this.IsEnter = false;
            this.GetWindow()?.Close();
        }

        #endregion

        #region SelectFolderCommand -- 选择文件夹命令

        /// <summary>
        /// 选择文件夹命令
        /// </summary>
        public VCommand SelectFolderCommand { get; set; }

        /// <summary>
        /// 选择文件夹
        /// </summary>
        private void SelectFolder()
        {
            System.Windows.Forms.FolderBrowserDialog fbd = new System.Windows.Forms.FolderBrowserDialog();
            if (fbd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            this.ProjectPath = fbd.SelectedPath;
        }

        #endregion
    }
}
