﻿using DevExpress.Utils.About;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Module
{
    /// <summary>
    /// VIZ设置视图模型
    /// </summary>
    public class VizSettingViewModel : ViewModelBase, ISettingViewModel
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(VizSettingViewModel));

        /// <summary>
        /// VIZ设置视图模型
        /// </summary>
        public VizSettingViewModel()
        {
            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.SelectEng3PathCommand = new VCommand(this.SelectEng3Path);
            this.SelectEng4PathCommand = new VCommand(this.SelectEng4Path);
        }

        // =========================================================================
        // Property
        // =========================================================================

        #region GH_IP -- GH IP

        private string gh_ip;
        /// <summary>
        /// GH_IP
        /// </summary>
        public string GH_IP
        {
            get { return gh_ip; }
            set { gh_ip = value; this.RaisePropertyChanged(nameof(GH_IP)); }
        }


        #endregion

        #region GH_Port -- GH 端口

        private int gh_port;
        /// <summary>
        /// GH 端口
        /// </summary>
        public int GH_Port
        {
            get { return gh_port; }
            set { gh_port = value; this.RaisePropertyChanged(nameof(GH_Port)); }
        }

        #endregion

        #region GH_ServerName -- GH 服务名

        private string gh_serverName;
        /// <summary>
        /// GH 服务名
        /// </summary>
        public string GH_ServerName
        {
            get { return gh_serverName; }
            set { gh_serverName = value; this.RaisePropertyChanged(nameof(GH_ServerName)); }
        }

        #endregion

        #region GH_UserName -- GH 用户名

        private string gh_userName;
        /// <summary>
        /// GH 用户名
        /// </summary>
        public string GH_UserName
        {
            get { return gh_userName; }
            set { gh_userName = value; this.RaisePropertyChanged(nameof(GH_UserName)); }
        }

        #endregion

        #region GH_Password -- GH 密码

        private string gh_password;
        /// <summary>
        /// GH 密码
        /// </summary>
        public string GH_Password
        {
            get { return gh_password; }
            set { gh_password = value; this.RaisePropertyChanged(nameof(GH_Password)); }
        }

        #endregion

        // -----------------------------------

        #region VIZ_IP -- VIZ IP

        private string viz_ip;
        /// <summary>
        /// VIZ_IP
        /// </summary>
        public string VIZ_IP
        {
            get { return viz_ip; }
            set { viz_ip = value; this.RaisePropertyChanged(nameof(VIZ_IP)); }
        }

        #endregion

        #region VIZ_Port -- VIZ 端口

        private int viz_port;
        /// <summary>
        /// VIZ 端口
        /// </summary>
        public int VIZ_Port
        {
            get { return viz_port; }
            set { viz_port = value; this.RaisePropertyChanged(nameof(VIZ_Port)); }
        }

        #endregion

        #region VIZ_UserName -- VIZ 用户名

        private string viz_userName;
        /// <summary>
        /// VIZ 用户名
        /// </summary>
        public string VIZ_UserName
        {
            get { return viz_userName; }
            set { viz_userName = value; this.RaisePropertyChanged(nameof(VIZ_UserName)); }
        }

        #endregion

        #region VIZ_Password -- VIZ 密码

        private string viz_password;
        /// <summary>
        /// VIZ 密码
        /// </summary>
        public string VIZ_Password
        {
            get { return viz_password; }
            set { viz_password = value; this.RaisePropertyChanged(nameof(VIZ_Password)); }
        }

        #endregion

        #region VIZ_Eng3Path -- VIZ 引擎3路径

        private string viz_eng3path;
        /// <summary>
        /// VIZ 引擎3路径
        /// </summary>
        public string VIZ_Eng3Path
        {
            get { return viz_eng3path; }
            set { viz_eng3path = value; this.RaisePropertyChanged(nameof(VIZ_Eng3Path)); }
        }

        #endregion

        #region VIZ_Eng4Path -- VIZ 引擎4路径

        private string viz_eng4path;
        /// <summary>
        /// VIZ 引擎4路径
        /// </summary>
        public string VIZ_Eng4Path
        {
            get { return viz_eng4path; }
            set { viz_eng4path = value; this.RaisePropertyChanged(nameof(VIZ_Eng4Path)); }
        }

        #endregion

        // =========================================================================
        // Command
        // =========================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            LocalInfoEntity info = ApplicationDomainEx.DataBaseManager.LocalInfo;

            this.GH_IP = info.GH_IP;
            this.GH_Port = info.GH_Port;
            this.GH_ServerName = info.GH_ServerName;
            this.GH_UserName = info.GH_UserName;
            this.GH_Password = info.GH_Password;

            this.VIZ_IP = info.VIZ_IP;
            this.VIZ_Port = info.VIZ_Port;
            this.VIZ_UserName = info.VIZ_UserName;
            this.VIZ_Password = info.VIZ_Password;
            this.VIZ_Eng3Path = info.VIZ_Eng3Path;
            this.VIZ_Eng4Path = info.VIZ_Eng4Path;
        }

        #endregion

        #region SelectEng3PathCommand -- 选择引擎3路径命令

        /// <summary>
        /// 选择引擎3路径命令
        /// </summary>
        public VCommand SelectEng3PathCommand { get; set; }

        /// <summary>
        /// 选择引擎3路径
        /// </summary>
        private void SelectEng3Path()
        {
            System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();
            ofd.Multiselect = false;
            ofd.Filter = "应用程序|*.exe";

            if (ofd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            this.VIZ_Eng3Path = ofd.FileName;
        }

        #endregion

        #region SelectEng4PathCommand -- 选择引擎4路径命令

        /// <summary>
        /// 选择引擎4路径命令
        /// </summary>
        public VCommand SelectEng4PathCommand { get; set; }

        /// <summary>
        /// 选择引擎4
        /// </summary>
        private void SelectEng4Path()
        {
            System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();
            ofd.Multiselect = false;
            ofd.Filter = "应用程序|*.exe";

            if (ofd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            this.VIZ_Eng4Path = ofd.FileName;
        }

        #endregion

        // =========================================================================
        // Public Function
        // =========================================================================

        /// <summary>
        /// 保存
        /// </summary>
        public void Save()
        {
            LocalInfoEntity info = ApplicationDomainEx.DataBaseManager.LocalInfo;

            info.GH_IP = this.GH_IP;
            info.GH_Port = this.GH_Port;
            info.GH_ServerName = this.GH_ServerName;
            info.GH_UserName = this.GH_UserName;
            info.GH_Password = this.GH_Password;

            info.VIZ_IP = this.VIZ_IP;
            info.VIZ_Port = this.VIZ_Port;
            info.VIZ_UserName = this.VIZ_UserName;
            info.VIZ_Password = this.VIZ_Password;
            info.VIZ_Eng3Path = this.VIZ_Eng3Path;
            info.VIZ_Eng4Path = this.VIZ_Eng4Path;

            ApplicationDomainEx.DataBaseManager.LiteDbContext.LocalInfo.Upsert(info);
        }
    }
}
