﻿using DevExpress.DirectX.Common.Direct2D;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Module;
using VIZ.TVP.Domain;

namespace VIZ.TVP.Module
{
    public class AppSetup_InitMedia : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitMedia));


        public override string Detail { get; } = "应用程序启动 -- 初始化媒体资源库";

        public override bool Setup(AppSetupContext context)
        {
            ApplicationDomainEx.DataBaseManager.ConfigContext = new Storage.ConfigContext();

            this.LoadConfig();

            return true;
        }

        /// <summary>
        /// 加载插件配置
        /// </summary>
        private void LoadConfig()
        {
            string folder = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "config");
            if (!System.IO.Directory.Exists(folder))
            {
                System.IO.Directory.CreateDirectory(folder);
            }

            string path = System.IO.Path.Combine(folder, "MediaResouce.config");

            ApplicationDomainEx.DataBaseManager.ConfigContext.LoadMediaConfig(path);
        }


        public override void Shutdown(AppSetupContext context)
        {
           
        }
    }
}
