﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.TVP.Domain;
using VIZ.TVP.Storage;

namespace VIZ.TVP.Service
{
    /// <summary>
    /// VIZ命令服务
    /// </summary>
    public interface IVizCommandService
    {
        /// <summary>
        /// 设置场景
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="scene">场景</param>
        /// <param name="layer">图层</param>
        void SetObject(TVPConnectionModel connection, string scene, VizLayerEnum layer);

        /// <summary>
        /// 播放
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="scene">场景</param>
        /// <param name="layer">图层</param>
        void Start(TVPConnectionModel connection, string scene, VizLayerEnum layer);

        /// <summary>
        /// 继续
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="scene">场景</param>
        /// <param name="layer">图层</param>
        void Continue(TVPConnectionModel connection, string scene, VizLayerEnum layer);

        /// <summary>
        /// 停止
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="scene">场景</param>
        /// <param name="layer">图层</param>
        void Stop(TVPConnectionModel connection, string scene, VizLayerEnum layer);

        /// <summary>
        /// 显示安全框
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="show">是否显示</param>
        void ShowTS(TVPConnectionModel connection, bool show);

        /// <summary>
        /// 显示安区域
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="show">是否显示</param>
        void ShowSA(TVPConnectionModel connection, bool show);

        /// <summary>
        /// 显示边界框
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="show">是否显示</param>
        void ShowBB(TVPConnectionModel connection, bool show);

        /// <summary>
        /// 显示RGB
        /// </summary>
        /// <param name="connection">连接</param>
        void ShowRGB(TVPConnectionModel connection);

        /// <summary>
        /// 显示键
        /// </summary>
        /// <param name="connection">连接</param>
        void ShowKey(TVPConnectionModel connection);

        /// <summary>
        /// 显示预览键
        /// </summary>
        /// <param name="connection">连接</param>
        void ShowKeyPreview(TVPConnectionModel connection);

        /// <summary>
        /// 上版子
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="scene">场景</param>
        /// <param name="layer">层</param>s
        /// <param name="use_all_directors">使用所有控制器</param>
        void TakeIn(TVPConnectionModel connection, string scene, VizLayerEnum layer, bool use_all_directors);

        /// <summary>
        /// 继续版子
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="layer">层</param>s
        void TakeContinue(TVPConnectionModel connection, VizLayerEnum layer);

        /// <summary>
        /// 下版子
        /// </summary>
        /// <param name="connection">连接</param>
        /// <param name="layer">层</param>s
        void TakeOut(TVPConnectionModel connection, VizLayerEnum layer);
    }
}
