﻿using CsvHelper;
using log4net;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.Storage
{
    public class ConfigContext
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(ConfigContext));


        public Configuration configuration { get; set; }

        /// <summary>
        /// 加载插件配置
        /// </summary>
        /// <param name="path">文件路径</param>
        public void LoadMediaConfig(string path)
        {
            
            if (File.Exists(path) == false)
            {
                {
                    string msg = string.Format("{0}路径下的文件未找到 ", path);
                    throw new FileNotFoundException(msg);
                }
            }
            try
            {
                ExeConfigurationFileMap configFile = new ExeConfigurationFileMap();
                configFile.ExeConfigFilename = path;
                configuration = ConfigurationManager.OpenMappedExeConfiguration(configFile, ConfigurationUserLevel.None);
           
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }

        }

    }
}
