﻿using LiteDB;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// 项目上下文
    /// </summary>
    public class ProjectContext : IDisposable
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(ProjectContext));

        /// <summary>
        /// 数据库
        /// </summary>
        private ILiteDatabase Database;

        /// <summary>
        /// LiteDB数据库
        /// </summary>
        /// <param name="path">数据库路径</param>
        public ProjectContext(string path)
        {
            this.Path = path;

            this.Database = new LiteDatabase(path);

            this.ProgramTemplate = this.Database.GetCollection<ProgramTemplateEntity>();
            this.ProgramList = this.Database.GetCollection<ProgramListEntity>();
        }

        /// <summary>
        /// 数据库文件路径
        /// </summary>
        public string Path { get; private set; }

        /// <summary>
        /// 节目模板
        /// </summary>
        public ILiteCollection<ProgramTemplateEntity> ProgramTemplate { get; private set; }

        /// <summary>
        /// 节目单
        /// </summary>
        public ILiteCollection<ProgramListEntity> ProgramList { get; private set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.Database?.Dispose();
        }
    }
}