﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.TVP.Storage
{
    /// <summary>
    /// GH author节点
    /// </summary>
    public class GH_Author_Node : IXmlSerialize
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            if (element == null)
                return;

            this.name = element.Element(XName.Get("name", GH_Xmlns_Enums.xmlns))?.Value;
        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            throw new NotSupportedException();
        }
    }
}
