﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Xml.Linq;
using VIZ.TVP.Service;
using VIZ.TVP.Storage;

namespace VIZ.TVP.UnitTest
{
    /// <summary>
    /// GH 服务测试
    /// </summary>
    [TestClass]
    public class ControlObjectTest
    {
        [TestMethod]
        public void FromXmlTest()
        {
            IVizCommandControlObjectService service = new VizCommandControlObjectService();

            string path = @"E:\Projects\VIZ.TVP\Doc\ControlObject_xml数据格式.xml";
            using (System.IO.StreamReader sr = new System.IO.StreamReader(path))
            {
                string xml = sr.ReadToEnd();

                service.GetControlObjectXmlData(xml, null, out var columns, out var items);

                string output = service.GetControlObjectXml(items);
            }
        }

        [TestMethod]
        public void ToXmlTest()
        {
            string path = @"E:\Projects\VIZ.TVP\Doc\ControlObject_xml数据格式.xml";
            using (System.IO.FileStream fs = new System.IO.FileStream(path, System.IO.FileMode.Open, System.IO.FileAccess.Read))
            {
                XElement element = XElement.Load(fs);
                ControlObject_Entry_Node root = new ControlObject_Entry_Node();
                root.FromXmlElement(element);

                XElement output = root.ToXmlElement();
            }
        }

        [TestMethod]
        public void XmlDefineTest()
        {
            string path = @"E:\Projects\VIZ.TVP\Doc\ControlObject_xml列定义.xml";
            using (System.IO.FileStream fs = new System.IO.FileStream(path, System.IO.FileMode.Open, System.IO.FileAccess.Read))
            {
                XElement element = XElement.Load(fs);
                ControlObject_Field_node root = new ControlObject_Field_node();
                root.FromXmlElement(element);
            }
        }
    }
}
