﻿using CsvHelper;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.TimeSlice.Storage
{
    /// <summary>
    /// CSV数据上下文
    /// </summary>
    public class CsvContext
    {
        /// <summary>
        /// 切片纯色背景集合
        /// </summary>
        public List<SliceBackground> SliceBackgrounds { get; private set; }

        /// <summary>
        /// 切片分辨率集合
        /// </summary>
        public List<SliceResolution> SliceResolutions { get; private set; }

        /// <summary>
        /// 切片输出格式集合
        /// </summary>
        public List<SliceFormat> SliceFormats { get; private set; }

        /// <summary>
        /// 加载切片纯色背景集合
        /// </summary>
        /// <param name="path">文件路径</param>
        public void LoadSliceBackgrounds(string path)
        {
            using (StreamReader sr = new StreamReader(path, Encoding.Default))
            using (CsvReader reader = new CsvReader(sr, CultureInfo.InvariantCulture))
            {
                this.SliceBackgrounds = reader.GetRecords<SliceBackground>()?.ToList();
            }
        }

        /// <summary>
        /// 加载切片纯色背景集合
        /// </summary>
        /// <param name="path">文件路径</param>
        public void LoadSliceResolutions(string path)
        {
            using (StreamReader sr = new StreamReader(path, Encoding.Default))
            using (CsvReader reader = new CsvReader(sr, CultureInfo.InvariantCulture))
            {
                this.SliceResolutions = reader.GetRecords<SliceResolution>()?.ToList();
            }
        }

        /// <summary>
        /// 加载切片纯色背景集合
        /// </summary>
        /// <param name="path">文件路径</param>
        public void LoadSliceFormats(string path)
        {
            using (StreamReader sr = new StreamReader(path, Encoding.Default))
            using (CsvReader reader = new CsvReader(sr, CultureInfo.InvariantCulture))
            {
                this.SliceFormats = reader.GetRecords<SliceFormat>()?.ToList();
            }
        }
    }
}
