﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Storage;

namespace VIZ.TimeSlice.Storage
{
    /// <summary>
    /// 客户端配置
    /// </summary>
    public class ClientConfig : IniConfigBase
    {
        /// <summary>
        /// 推送消息地址
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "http://localhost:8888/olympic/pull/message?status=1&path={path}", Type = typeof(string))]
        public string CLIENT_PULL_MESSAGE_URL { get; set; }

        /// <summary>
        /// 推送间隔限制（单位：毫秒）
        /// </summary>
        [Ini(Section = "Client", DefaultValue = "3000", Type = typeof(int))]
        public string CLIENT_PULL_MESSAGE_INTERVAL { get; set; }
    }
}
