﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Storage;

namespace VIZ.TimeSlice.Storage
{
    /// <summary>
    /// 切片配置
    /// </summary>
    public class SliceConfig : IniConfigBase
    {
        /// <summary>
        /// 工作目录
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "c:\\", Type = typeof(string))]
        public string path { get; set; }

        /// <summary>
        /// 视频背景 0 - 纯色 | 1 - 视频帧 | 2 - 图片文件
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "0", Type = typeof(int))]
        public string videobackground { get; set; }

        /// <summary>
        /// 纯色背景
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "0", Type = typeof(string))]
        public string background { get; set; }

        /// <summary>
        /// 背景图片路径
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "", Type = typeof(string))]
        public string imagepath { get; set; }

        /// <summary>
        /// 绘制左上角X坐标
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "500", Type = typeof(int))]
        public string positionX { get; set; }

        /// <summary>
        /// 绘制左上角Y坐标
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "400", Type = typeof(int))]
        public string positionY { get; set; }

        /// <summary>
        /// 取值范围2-20，每X帧保留1帧
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "5", Type = typeof(int))]
        public string frames { get; set; }

        /// <summary>
        /// 分辨率
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "4K", Type = typeof(string))]
        public string resolution { get; set; }

        /// <summary>
        /// 帧率
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "50", Type = typeof(int))]
        public string fps { get; set; }

        /// <summary>
        /// 帧率
        /// </summary>
        [Ini(Section = "slice", DefaultValue = "mp4", Type = typeof(string))]
        public string format { get; set; }
    }
}
