﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using VIZ.TimeSlice.Domain;
using VIZ.TimeSlice.Storage;

namespace VIZ.TimeSlice.Module.Resource
{
    /// <summary>
    /// 推送消息URL地址转化器
    /// </summary>
    public class PullMessageUrlConverter : IValueConverter
    {
        /// <summary>
        /// 推送消息地址
        /// </summary>
        /// <remarks>
        /// 示例: http://localhost:8888/olympic/pull/message?status=1&path={path}
        /// </remarks>
        private readonly static string CLIENT_PULL_MESSAGE_URL = ApplicationDomainEx.IniStorage.GetValue<ClientConfig, string>(p => p.CLIENT_PULL_MESSAGE_URL);

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string path = (value ?? string.Empty).ToString();

            return CLIENT_PULL_MESSAGE_URL.Replace("{path}", path);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
