﻿using log4net;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Management;
using VIZ.Framework.Core;
using VIZ.Framework.Connection;
using VIZ.Framework.Module;
using VIZ.TimeSlice.Domain;
using CsvHelper;
using System.Globalization;
using System.IO;

namespace VIZ.TimeSlice.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化CSV数据
    /// </summary>
    public class AppSetup_InitCSV : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitCSV));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化CSV数据";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            // 切片 纯色背景
            string path_background = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "config", "slice_background.csv");
            ApplicationDomainEx.CsvContext.LoadSliceBackgrounds(path_background);

            // 切片 分辨率
            string path_resolution = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "config", "slice_resolution.csv");
            ApplicationDomainEx.CsvContext.LoadSliceResolutions(path_resolution);

            // 切片 输出格式
            string path_format = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "config", "slice_format.csv");
            ApplicationDomainEx.CsvContext.LoadSliceFormats(path_format);

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {

        }
    }
}
