﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Module;
using VIZ.TimeSlice.Module;

namespace VIZ.TimeSlice
{
    /// <summary>
    /// App.xaml 的交互逻辑
    /// </summary>
    public partial class App : Application
    {
        public App()
        {
            // 初始化CSV
            AppSetup.AppendSetup(new AppSetup_InitCSV());

            // 执行启动流程
            AppSetupContext context = AppSetup.Setup();

            if (context.Exception != null)
            {
                MessageBox.Show($"执行 {context.ProviderDetail} 失败\r\n{context.Exception.Message}");
            }

            if (!context.IsSuccess)
            {
                Environment.Exit(-1);
            }
        }
    }
}
