﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Management;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 网络辅助类
    /// </summary>
    public static class NetHelper
    {
        /// <summary>
        /// 获取当前使用的网卡或排序最后的有效网卡地址
        /// </summary>
        /// <returns>获取当前使用的或最后一个网卡地址</returns>
        public static string GetUsedOrLastMacAddress()
        {
            try
            {
                List<string> list = new List<string>();

                ManagementClass mc = new ManagementClass("Win32_NetworkAdapterConfiguration");
                ManagementObjectCollection moc = mc.GetInstances();
                foreach (ManagementObject mo in moc)
                {
                    bool mac_ipEnabled = (bool)mo["IPEnabled"];
                    string mac_address = mo["MacAddress"]?.ToString()?.ToUpper();
                    string mac_description = mo["Description"]?.ToString()?.ToLower();

                    if (string.IsNullOrWhiteSpace(mac_address) || string.IsNullOrWhiteSpace(mac_description))
                        continue;

                    if (mac_description.Contains("debug") || mac_description.Contains("virtual") || mac_description.Contains("miniport"))
                        continue;

                    if (mac_ipEnabled)
                        return mac_address;

                    list.Add(mac_address);
                }
                moc.Dispose();
                mc.Dispose();
                moc = null;
                mc = null;

                return list.LastOrDefault() ?? string.Empty;
            }
            catch
            {
                return string.Empty;
            }
        }

        /// <summary>
        /// 获取所有有效的Mac地址
        /// </summary>
        /// <returns>Mac地址</returns>
        public static List<string> GetAllMacAddress()
        {
            List<string> result = new List<string>();

            try
            {
                ManagementClass mc = new ManagementClass("Win32_NetworkAdapterConfiguration");
                ManagementObjectCollection moc = mc.GetInstances();
                foreach (ManagementObject mo in moc)
                {
                    string mac_address = mo["MacAddress"]?.ToString()?.ToUpper();
                    string mac_description = mo["Description"]?.ToString()?.ToLower();

                    if (string.IsNullOrWhiteSpace(mac_address) || string.IsNullOrWhiteSpace(mac_description))
                        continue;

                    if (mac_description.Contains("debug") || mac_description.Contains("virtual") || mac_description.Contains("miniport"))
                        continue;

                    result.Add(mac_address);
                }
                moc.Dispose();
                mc.Dispose();
                moc = null;
                mc = null;

                return result;
            }
            catch
            {
                return result;
            }
        }

        /// <summary>
        /// 获取一个可用的UDP端口
        /// </summary>
        /// <param name="startPort">开始端口</param>
        /// <param name="endPort">结束端口</param>
        /// <param name="notIn">端口不应该再该列表中</param>
        /// <returns>可用的UDP端口</returns>
        public static int GetAvailableUdpPort(int startPort, int endPort, List<int> notIn)
        {
            //提供本地计算机有关网络连接信息
            IPGlobalProperties iPGlobalProperties = IPGlobalProperties.GetIPGlobalProperties();
            //获取可用的UDP监听终结点信息
            IPEndPoint[] iPEndPoints = iPGlobalProperties.GetActiveUdpListeners();

            for (int port = startPort; port <= endPort; port++)
            {
                if (notIn != null && notIn.Contains(port))
                    continue;

                if (iPEndPoints.Any(p => p.Port == port))
                    continue;

                return port;
            }

            return 0;
        }
    }
}
