﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// GPI设备 USB到GPI设备驱动 返回值
    /// </summary>
    public static class GPI_USB2GPI_DEVICE_RESULT
    {
        /// <summary>
        /// 函数执行成功
        /// </summary>
        public const Int32 GPIO_SUCCESS = 0;

        /// <summary>
        /// 适配器不支持该函数
        /// </summary>
        public const Int32 GPIO_ERR_NOT_SUPPORT = -1;

        /// <summary>
        /// USB写数据失败
        /// </summary>
        public const Int32 GPIO_ERR_USB_WRITE_FAIL = -2;

        /// <summary>
        /// USB读数据失败
        /// </summary>
        public const Int32 GPIO_ERR_USB_READ_FAIL = -3;

        /// <summary>
        /// 命令执行失败
        /// </summary>
        public const Int32 GPIO_ERR_CMD_FAIL = -4;
    }

    /// <summary>
    /// GPI设备 USB到GPI设备驱动
    /// </summary>
    public static class GPI_USB2GPI_DEVICE
    {
        /// <summary>
        /// 将GPIO引脚设置为输入模式
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <param name="PinMask">需要设置为输入模式的引脚，每个bit位代表一个引脚，对应bit位为1时改引脚对设置有效，最低位为P0</param>
        /// <param name="PuPd">0-浮空输入，无上拉或者下拉，1-上拉输入，2-下拉输入</param>
        /// <returns>函数执行状态，小于0函数执行出错<see cref="GPI_USB2GPI_DEVICE_RESULT"/></returns>
        [DllImport("USB2XXX.dll")]
        public static extern Int32 GPIO_SetInput(IntPtr DevHandle, UInt32 PinMask, Byte PuPd);

        /// <summary>
        /// 将GPIO引脚设置为输出模式
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <param name="PinMask">需要设置为输入模式的引脚，每个bit位代表一个引脚，对应bit位为1时改引脚对设置有效，最低位为P0</param>
        /// <param name="PuPd">0-浮空输入，无上拉或者下拉，1-上拉输入，2-下拉输入</param>
        /// <returns>函数执行状态，小于0函数执行出错<see cref="GPI_USB2GPI_DEVICE_RESULT"/></returns>
        [DllImport("USB2XXX.dll")]
        public static extern Int32 GPIO_SetOutput(IntPtr DevHandle, UInt32 PinMask, Byte PuPd);

        /// <summary>
        /// 将GPIO引脚设置为开漏模式，该模式下可作为双向引脚
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <param name="PinMask">需要设置为输入模式的引脚，每个bit位代表一个引脚，对应bit位为1时改引脚对设置有效，最低位为P0</param>
        /// <param name="PuPd">0-浮空输入，无上拉或者下拉，1-上拉输入，2-下拉输入</param>
        /// <returns>函数执行状态，小于0函数执行出错<see cref="GPI_USB2GPI_DEVICE_RESULT"/></returns>
        [DllImport("USB2XXX.dll")]
        public static extern Int32 GPIO_SetOpenDrain(IntPtr DevHandle, UInt32 PinMask, Byte PuPd);

        /// <summary>
        /// 设置GPIO引脚的输出状态
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <param name="PinMask">需要设置为输入模式的引脚，每个bit位代表一个引脚，对应bit位为1时改引脚对设置有效，最低位为P0</param>
        /// <param name="PinValue">对应引脚的状态，每个bit位代表一个引脚，对应bit位为1输出高电平，为0输出低电平，最低位对应P0</param>
        /// <returns>函数执行状态，小于0函数执行出错<see cref="GPI_USB2GPI_DEVICE_RESULT"/></returns>
        [DllImport("USB2XXX.dll")]
        public static extern Int32 GPIO_Write(IntPtr DevHandle, UInt32 PinMask, UInt32 PinValue);

        /// <summary>
        /// 设置GPIO引脚的输出状态
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <param name="PinMask">需要设置为输入模式的引脚，每个bit位代表一个引脚，对应bit位为1时改引脚对设置有效，最低位为P0</param>
        /// <param name="pPinValue">对应引脚的状态，每个bit位代表一个引脚，对应bit位为1引脚为高电平，为0引脚为低电平，最低位对应P0</param>
        /// <returns>函数执行状态，小于0函数执行出错<see cref="GPI_USB2GPI_DEVICE_RESULT"/></returns>
        [DllImport("USB2XXX.dll")]
        public static extern Int32 GPIO_Read(IntPtr DevHandle, UInt32 PinMask, ref UInt32 pPinValue);
    }
}
