﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 监视管理器
    /// </summary>
    public class MonitorManager : IMonitorManager
    {
        /// <summary>
        /// 任务列表
        /// </summary>
        private List<MonitorTaskBase> TaskList = new List<MonitorTaskBase>();

        /// <summary>
        /// 添加监视任务
        /// </summary>
        /// <param name="task">监视任务</param>
        public void AppendTask(MonitorTaskBase task)
        {
            this.TaskList.Add(task);
        }

        /// <summary>
        /// 添加触发器
        /// </summary>
        /// <param name="name">任务名称</param>
        /// <param name="trigger">触发器</param>
        public void AppendTrigger(string name, IMonitorTrigger trigger)
        {
            MonitorTaskBase task = this.TaskList.FirstOrDefault(p => p.Name == name);

            if (task == null)
                throw new Exception($"monitor: {name} not found.");

            task.Triggers.Add(trigger);
        }

        /// <summary>
        /// 获取监视信息
        /// </summary>
        /// <param name="name">监视名称</param>
        /// <returns>监视模型</returns>
        public T GetInfo<T>(string name) where T : MonitorInfolBase
        {
            MonitorTaskBase task = this.TaskList.FirstOrDefault(p => p.Name == name);

            return task?.Info as T;
        }

        /// <summary>
        /// 开始监控
        /// </summary>
        public void Start()
        {
            foreach (MonitorTaskBase task in this.TaskList)
            {
                task.Start();
            }
        }

        /// <summary>
        /// 停止监控
        /// </summary>
        public void Stop()
        {
            foreach (MonitorTaskBase task in this.TaskList)
            {
                task.Stop();
            }
        }
    }
}
