﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 3D鼠标辅助类
    /// </summary>
    public static class Navigation3DHelper
    {
        /// <summary>
        /// 初始化3D鼠标
        /// </summary>
        /// <param name="hWnd">窗口句柄</param>
        /// <returns>是否初始化完成</returns>
        [DllImport("VIZ.Framework.Core.Navigation3D.dll")]
        public extern static bool init_3D_Mouse(IntPtr hWnd);

        /// <summary>
        /// 销毁3D鼠标
        /// </summary>
        [DllImport("VIZ.Framework.Core.Navigation3D.dll")]
        public static extern void dispose_3D_Mouse();

        /// <summary>
        /// 处理3D鼠标消息
        /// </summary>
        /// <param name="wParam"></param>
        /// <param name="lParam"></param>
        /// <returns>3D鼠标数据</returns>
        [DllImport("VIZ.Framework.Core.Navigation3D.dll")]
        public static extern IntPtr on_message_3D_Mouse(IntPtr wParam, IntPtr lParam);

        /// <summary>
        /// 销毁3D鼠标数据
        /// </summary>
        /// <param name="data">3D鼠标数据</param>
        [DllImport("VIZ.Framework.Core.Navigation3D.dll")]
        public static extern void dispose_3D_Mouse_data(IntPtr data);
    }
}