﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 3D鼠标平滑
    /// </summary>
    public class Navigation3DSmooth
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(Navigation3DSmooth));

        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled { get; set; } = true;

        /// <summary>
        /// 平滑系数
        /// </summary>
        public double MinCutoff
        {
            get { return this.min_cutoff; }
            set { this.min_cutoff = value; }
        }

        private double min_cutoff;
        private double beta;
        private double d_cutoff;
        private double x_prev;
        private double dx_prev;
        //private Stopwatch stopwatch = new Stopwatch();
        //private long last_time;

        /// <summary>
        /// 初始化
        /// </summary>
        /// <param name="x0">开始值</param>
        /// <param name="dx0">之前的X值</param>
        /// <param name="min_cutoff">终止值</param>
        /// <param name="beta"></param>
        /// <param name="d_cutoff"></param>
        public void Init(double x0, double dx0 = 0, double min_cutoff = 0.07, double beta = 0, double d_cutoff = 1)
        {
            this.min_cutoff = min_cutoff;
            this.beta = beta;
            this.d_cutoff = d_cutoff;
            this.x_prev = x0;
            this.dx_prev = dx0;

            //this.last_time = 0;
            //this.stopwatch.Restart();
        }

        /// <summary>
        /// 根据实际值获取平滑值
        /// </summary>
        /// <param name="x">实际值</param>
        /// <param name="t_e">时间差</param>
        /// <returns>平滑后的值</returns>
        public double Call(double x, double t_e)
        {
            if (!this.IsEnabled)
                return x;

            if (t_e == 0)
                return this.x_prev;

            //long t = this.stopwatch.ElapsedMilliseconds;
            //double t_e = (t - this.last_time) / 100d;
            //this.last_time = t;

            double a_d = smoothing_factor(t_e, this.d_cutoff);
            double dx = (x - this.x_prev) / t_e;
            double dx_hat = exponential_smoothing(a_d, dx, this.x_prev);

            double cutoff = this.min_cutoff + this.beta * Math.Abs(dx_hat);
            double a = smoothing_factor(t_e, cutoff);
            double x_hat = exponential_smoothing(a, x, this.x_prev);

            this.x_prev = x_hat;
            this.dx_prev = dx_hat;

            return x_hat;
        }

        private double smoothing_factor(double t_e, double cutoff)
        {
            double r = 2 * Math.PI * cutoff * t_e;
            return r;
        }

        private double exponential_smoothing(double a, double x, double x_prev)
        {
            return a * x + (1 - a) * x_prev;
        }
    }
}