﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Connection;
using log4net;
using System.Runtime.Remoting.Messaging;
using VIZ.Framework.Core;

namespace VIZ.Framework.Module
{
    /// <summary>
    /// 3D鼠标TCP监听器
    /// </summary>
    public class Navigation3DTcpListener : TcpConnectionListener
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(Navigation3DTcpListener));

        /// <summary>
        /// 监听器键
        /// </summary>
        public const string LISTENER_KEY = "Navigation3DTcpListener";

        /// <summary>
        /// 监听器客户端键
        /// </summary>
        public const string LISTENER_CLIENT_KEY = "Navigation3DTcpListener_CLIENT";

        /// <summary>
        /// 3D鼠标TCP监听器
        /// </summary>
        /// <param name="ip">IP地址</param>
        /// <param name="port">端口</param>
        /// <param name="mappings">映射集合</param>
        public Navigation3DTcpListener(string ip, int port, List<Navigation3DMapping> mappings) : base(ip, port)
        {
            this.Key = LISTENER_KEY;
            this.Mappings = mappings;
        }

        /// <summary>
        /// 映射集合
        /// </summary>
        public List<Navigation3DMapping> Mappings { get; private set; }

        /// <summary>
        /// 创建终结点管理器
        /// </summary>
        /// <param name="tcpClient">TCP客户端</param>
        /// <returns>TCP终结点管理器</returns>
        protected override TcpEndpointManager CreateEndpointManager(TcpClient tcpClient)
        {
            TcpEndpointManager manager = new TcpEndpointManager(LISTENER_CLIENT_KEY, tcpClient);
            manager.PackageProvider = new Navigation3DCommandProvider(this.Mappings);

            return manager;
        }
    }
}
