﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Common;
using VIZ.Framework.Core;

namespace VIZ.Framework.WpfTest
{
    public class NavigationTestModel : ModelBase
    {
        private List<NavigationConfig> items;

        public List<NavigationConfig> Items
        {
            get { return items; }
            set { items = value; this.RaisePropertyChanged(nameof(items)); }
        }


        private NavigationConfig selectedItem;

        public NavigationConfig SelectedItem
        {
            get { return selectedItem; }
            set { selectedItem = value; this.RaisePropertyChanged(nameof(SelectedItem)); }
        }


    }

    /// <summary>
    /// NavigationTest2.xaml 的交互逻辑
    /// </summary>
    public partial class NavigationTest2 : UserControl
    {
        public NavigationTest2()
        {
            InitializeComponent();

            model = new NavigationTestModel();

            model.Items = new List<NavigationConfig>();
            model.Items.Add(new NavigationConfig { ViewType = typeof(UserControl1) });
            model.Items.Add(new NavigationConfig { ViewType = typeof(UserControl2) });

            this.DataContext = model;
        }

        private NavigationTestModel model;

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            model.SelectedItem = model.Items[0];
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            model.SelectedItem = model.Items[1];
        }
    }
}
