﻿using log4net;
using SharpDX.Direct2D1;
using SharpDX.Mathematics.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 手动校准插件
    /// </summary>
    public class ManualCorrectionPlugin : VideoPluginBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(ManualCorrectionPlugin));

        /// <summary>
        /// 手动校准插件
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public ManualCorrectionPlugin(VideoControl videoControl) : base(videoControl)
        {

        }

        /// <summary>
        /// 名称
        /// </summary>
        public override string Name => VideoControlPluginNames.ManualCorrection;

        /// <summary>
        /// 点击事件
        /// </summary>
        public event EventHandler<ManualCorrectionClickEventArgs> Click;

        /// <summary>
        /// 手动校准信息
        /// </summary>
        private volatile ManualCorrectionInfo manualCorrectionInfo;

        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="manualCorrectionInfo">跟踪框信息</param>
        public void Update(ManualCorrectionInfo manualCorrectionInfo)
        {
            this.manualCorrectionInfo = manualCorrectionInfo;
        }
        /// <summary>
        /// 渲染
        /// </summary>
        /// <param name="context">渲染上下文</param>
        public override void Render(VideoRenderContext context)
        {
            // 画面渲染区域
            ManualCorrectionInfo info = this.manualCorrectionInfo;
            if (info == null)
                return;

            SolidColorBrush brush = new SolidColorBrush(context.Target, info.FillColor);

            RawVector2 center = ImageHelper.ConvertImagePointToUiPoint(context.VideoRenderInfo.Frame.Width, context.VideoRenderInfo.Frame.Height, context.VideoRenderInfo.DrawingRect, info.SrcCenter);
            float radius = (float)ImageHelper.ConvertImageDistanceToUiDistanceUseX(context.VideoRenderInfo.Frame.Width, context.VideoRenderInfo.DrawingRect, info.SrcRadius);

            Ellipse ellipse = new Ellipse(center, radius, radius);

            context.Target.FillEllipse(ellipse, brush);
        }

        /// <summary>
        /// 附加
        /// </summary>
        public override void Attach()
        {
            this.VideoRender.PreviewMouseLeftButtonDown -= VideoRender_PreviewMouseLeftButtonDown;
            this.VideoRender.PreviewMouseLeftButtonDown += VideoRender_PreviewMouseLeftButtonDown;
        }

        /// <summary>
        /// 卸载
        /// </summary>
        public override void Detach()
        {
            this.VideoRender.PreviewMouseLeftButtonDown -= VideoRender_PreviewMouseLeftButtonDown;
        }

        /// <summary>
        /// 鼠标左键点击
        /// </summary>
        private void VideoRender_PreviewMouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            if (!this.IsEnabled || this.Click == null)
                return;

            VideoRenderInfo renderInfo = this.VideoRender.RenderInfo;
            if (renderInfo == null)
                return;

            ManualCorrectionClickEventArgs args = new ManualCorrectionClickEventArgs();
            args.MousePoint = e.GetPosition(this.VideoRender);
            args.SrcPoint = ImageHelper.ConvertUiPointToImagePoint(renderInfo.Frame.Width, renderInfo.Frame.Height, renderInfo.DrawingRect, args.MousePoint);

            this.Click.Invoke(this, args);
        }
    }
}