﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 边线检测多边形扩展
    /// </summary>
    public static class SideCheckPolygonExpand
    {
        /// <summary>
        /// 更新边线检测多边形
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        /// <param name="sideCheckPolygonInfos">边线检测多边形信息</param>
        public static void UpdateSideCheckPolygon(this VideoControl videoControl, List<SideCheckPolygonInfo> sideCheckPolygonInfos)
        {
            if (videoControl.videoRender == null)
                return;

            SideCheckPolygonPlugin plugin = videoControl.GetPlugin<SideCheckPolygonPlugin>(VideoControlPluginNames.SideCheckPolygon);
            if (plugin == null)
                return;

            plugin.Update(sideCheckPolygonInfos);
        }

        /// <summary>
        /// 清理边线检测多边形
        /// </summary>
        /// <param name="videoControl">视频控件</param>
        public static void ClearSideCheckPolygon(this VideoControl videoControl)
        {
            if (videoControl.videoRender == null)
                return;

            SideCheckPolygonPlugin plugin = videoControl.GetPlugin<SideCheckPolygonPlugin>(VideoControlPluginNames.SideCheckPolygon);
            if (plugin == null)
                return;

            plugin.Update(null);
        }
    }
}
