﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using SharpDX;
using SharpDX.Direct2D1;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 视频帧
    /// </summary>
    public interface IVideoFrame : IVideoControlSync, IDisposable
    {
        /// <summary>
        /// 宽度
        /// </summary>
        int Width { get; set; }

        /// <summary>
        /// 高度
        /// </summary>
        int Height { get; set; }

        /// <summary>
        /// 数据长度
        /// </summary>
        int Length { get; set; }

        /// <summary>
        /// 是否是最后一帧
        /// </summary>
        bool IsEnd { get; set; }

        /// <summary>
        /// 画面数据
        /// </summary>
        DataStream DataStream { get; set; }
    }
}
