﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 热键输入框
    /// </summary>
    [TemplatePart(Name = nameof(PART_TextBox), Type = typeof(TextBox))]
    public class HotkeyBox : Control
    {
        static HotkeyBox()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(HotkeyBox), new FrameworkPropertyMetadata(typeof(HotkeyBox)));
        }

        /// <summary>
        /// 输入框
        /// </summary>
        private TextBox PART_TextBox;

        #region Hotkey -- 热键

        /// <summary>
        /// 热键
        /// </summary>
        public string Hotkey
        {
            get { return (string)GetValue(HotkeyProperty); }
            set { SetValue(HotkeyProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Hotkey.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty HotkeyProperty =
            DependencyProperty.Register("Hotkey", typeof(string), typeof(HotkeyBox), new PropertyMetadata(null));

        #endregion

        /// <summary>
        /// 应用模板
        /// </summary>
        public override void OnApplyTemplate()
        {
            base.OnApplyTemplate();

            this.PART_TextBox = this.Template.FindName(nameof(this.PART_TextBox), this) as TextBox;
            if (this.PART_TextBox == null)
                return;

            this.PART_TextBox.IsReadOnly = true;
            this.PART_TextBox.PreviewKeyDown -= PART_TextBox_PreviewKeyDown;
            this.PART_TextBox.PreviewKeyDown += PART_TextBox_PreviewKeyDown;
        }

        /// <summary>
        /// 按钮按下
        /// </summary>
        private void PART_TextBox_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            e.Handled = true;

            this.Hotkey = HotkeyHelper.GetHotkey(e);
        }
    }
}
