﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 标签和值
    /// </summary>
    public class LabelValue2 : Control
    {
        static LabelValue2()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(LabelValue2), new FrameworkPropertyMetadata(typeof(LabelValue2)));
        }

        #region LabelWidth -- 标签宽度

        /// <summary>
        /// 标签宽度
        /// </summary>
        public double LabelWidth
        {
            get { return (double)GetValue(LabelWidthProperty); }
            set { SetValue(LabelWidthProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for LabelWidth.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty LabelWidthProperty =
            DependencyProperty.Register("LabelWidth", typeof(double), typeof(LabelValue2), new PropertyMetadata(120d));

        #endregion

        #region Label -- 标签

        /// <summary>
        /// 标签
        /// </summary>
        public string Label
        {
            get { return (string)GetValue(LabelProperty); }
            set { SetValue(LabelProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Label.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty LabelProperty =
            DependencyProperty.Register("Label", typeof(string), typeof(LabelValue2), new PropertyMetadata(null));

        #endregion

        #region Text1 -- 文本1

        /// <summary>
        /// 文本1
        /// </summary>
        public string Text1
        {
            get { return (string)GetValue(Text1Property); }
            set { SetValue(Text1Property, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Text1.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty Text1Property =
            DependencyProperty.Register("Text1", typeof(string), typeof(LabelValue2), new PropertyMetadata(null));

        #endregion

        #region Text2 -- 文本2

        /// <summary>
        /// 文本2
        /// </summary>
        public string Text2
        {
            get { return (string)GetValue(Text2Property); }
            set { SetValue(Text2Property, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for Text2.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty Text2Property =
            DependencyProperty.Register("Text2", typeof(string), typeof(LabelValue2), new PropertyMetadata(null));

        #endregion
    }
}
