﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media;
using System.Windows.Controls;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 空窗口
    /// </summary>
    public class NoneWindow : Window
    {
        /// <summary>
        /// 窗口
        /// </summary>
        /// <param name="width">窗口宽度</param>
        /// <param name="height">窗口高度</param>
        /// <param name="content">窗口内容</param>
        public NoneWindow(double width, double height, Control content)
        {
            this.WindowStartupLocation = WindowStartupLocation.CenterScreen;
            this.WindowState = WindowState.Normal;
            this.WindowStyle = WindowStyle.None;
            this.Background = new SolidColorBrush(Colors.Transparent);
            this.AllowsTransparency = true;
            this.Width = width;
            this.Height = height;
            this.Content = content;
            content.Margin = new Thickness(10, 10, 10, 10);
        }
    }
}
