﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 网络辅助类 Mac信息
    /// </summary>
    public class NetHelperMacInfo
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 物理地址
        /// </summary>
        public string PhysicalAddress { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// DHCPv6 客户端 DUID
        /// </summary>
        public string DHCPv6ClientDUID { get; set; }

        /// <summary>
        /// 是否可用
        /// </summary>
        /// <returns>是否可用</returns>
        public bool IsAvailable()
        {
            return !string.IsNullOrWhiteSpace(this.PhysicalAddress) || !string.IsNullOrWhiteSpace(this.DHCPv6ClientDUID);
        }

        /// <summary>
        /// 转化为字符串
        /// </summary>
        /// <returns>字符串</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();

            sb.AppendLine($"Name . . . . . . . . . . : {this.Name}");
            sb.AppendLine($"Description. . . . . . . : {this.Description}");
            sb.AppendLine($"Physical Address . . . . : {this.PhysicalAddress}");
            sb.AppendLine($"DHCPv6 Client DUID . . . : {this.DHCPv6ClientDUID}");

            return sb.ToString();
        }
    }

}
