﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 模型基类
    /// </summary>
    public abstract class ModelBase : INotifyPropertyChanged, INotifyPropertyChanging
    {
        /// <summary>
        /// 属性改变前事件
        /// </summary>
        public event PropertyChangingEventHandler PropertyChanging;

        /// <summary>
        /// 属性改变后事件
        /// </summary>
        public event PropertyChangedEventHandler PropertyChanged;

        /// <summary>
        /// 触发属性改变前事件
        /// </summary>
        /// <param name="propertyName">属性名</param>
        public void RaisePropertyChanging(string propertyName)
        {
            this.PropertyChanging?.Invoke(this, new PropertyChangingEventArgs(propertyName));
        }

        /// <summary>
        /// 触发属性改变前事件（安全方式）
        /// </summary>
        /// <param name="propertyName">属性名</param>
        public void RaisePropertySaveChanging(string propertyName)
        {
            if (Application.Current.Dispatcher.CheckAccess())
            {
                this.PropertyChanging?.Invoke(this, new PropertyChangingEventArgs(propertyName));

                return;
            }

            WPFHelper.Invoke(() =>
            {
                this.PropertyChanging?.Invoke(this, new PropertyChangingEventArgs(propertyName));
            });
        }

        /// <summary>
        /// 触发属性改变后事件
        /// </summary>
        /// <param name="propertyName">属性名</param>
        public void RaisePropertyChanged(string propertyName)
        {
            this.PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }

        /// <summary>
        /// 触发属性改变后事件（安全方式）
        /// </summary>
        /// <param name="propertyName">属性名</param>
        public void RaisePropertySaveChanged(string propertyName)
        {
            if (Application.Current.Dispatcher.CheckAccess())
            {
                this.PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));

                return;
            }

            WPFHelper.Invoke(() =>
            {
                this.PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
            });
        }
    }
}
