﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Framework.Storage;

namespace VIZ.Framework.Domain
{
    /// <summary>
    /// 应用程序域
    /// </summary>
    public class ApplicationDomain
    {
        protected ApplicationDomain() { }

        /// <summary>
        /// INI 仓储
        /// </summary>
        public static IniStorage IniStorage { get; private set; } = new IniStorage(System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "config", "config.ini"));

        /// <summary>
        /// 消息管理器
        /// </summary>
        public static IMessageManager MessageManager { get; private set; } = new MessageManager();

        /// <summary>
        /// 延时管理器
        /// </summary>
        public static IDelayManager DelayManager { get; private set; } = new DelayManager();

        /// <summary>
        /// 服务管理器
        /// </summary>
        public static IServiceManager ServiceManager { get; private set; } = new ServiceManager();

        /// <summary>
        /// 循环管理器
        /// </summary>
        public static ILoopManager LoopManager { get; private set; } = new LoopManager();

        /// <summary>
        /// 监控管理器
        /// </summary>
        public static IMonitorManager MonitorManager { get; private set; } = new MonitorManager();

        /// <summary>
        /// 是否是调试模式
        /// </summary>
        public static bool IS_DEBUG { get; private set; }

        /// <summary>
        /// 本机逻辑MAC
        /// </summary>
        public static string LOCAL_LOGIC_MAC { get; private set; }

        static ApplicationDomain()
        {
            // 是否是调试模式
            IS_DEBUG = IniStorage.GetValue<ApplicationConfig, bool>(p => p.APPLICATION_IS_DEBUG);

            // 本机使用的逻辑MAC地址
            NetHelperMacInfo macInfo = NetHelper.GetAllMacAddressWithDefaultFilter().FirstOrDefault(p => p.IsAvailable());
            string mac = macInfo.DHCPv6ClientDUID;
            if (!string.IsNullOrWhiteSpace(macInfo.PhysicalAddress))
            {
                mac = macInfo.PhysicalAddress;
            }
            LOCAL_LOGIC_MAC = mac;
        }
    }
}
