﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using OpenCvSharp;
using OpenCvSharp.WpfExtensions;

namespace VIZ.Framework.ImageContrastTool
{
    /// <summary>
    /// 路径转图片转化器
    /// </summary>
    public class PathToImageConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string path = value as string;
            if (string.IsNullOrWhiteSpace(path))
                return null;

            if (!System.IO.File.Exists(path))
                return null;

            Mat mat = new Mat(path);
            var result = mat.ToBitmapSource();
            mat.Dispose();

            return result;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
