﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Storage
{
    /// <summary>
    /// 应用程序配置
    /// </summary>
    public class ApplicationConfig : IniConfigBase
    {
        /// <summary>
        /// 是否是调试模式 （True | Flase）
        /// </summary>
        [Ini(Section = "Application", DefaultValue = "False", Type = typeof(bool))]
        public string APPLICATION_IS_DEBUG { get; set; }

        /// <summary>
        /// 3D鼠标平滑系数
        /// </summary>
        [Ini(Section = "Application", DefaultValue = "0.015", Type = typeof(bool))]
        public string APPLICATION_3D_MOUSE_SMOOTH_COEFFICIENT { get; set; }

        /// <summary>
        /// 3D鼠标TCP IP
        /// </summary>
        [Ini(Section = "Application", DefaultValue = "127.0.0.1", Type = typeof(string))]
        public string APPLICATION_3D_MOUSE_TCP_IP { get; set; }

        /// <summary>
        /// 3D鼠标TCP 端口
        /// </summary>
        [Ini(Section = "Application", DefaultValue = "8201", Type = typeof(int))]
        public string APPLICATION_3D_MOUSE_TCP_PORT { get; set; }
    }
}
