﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// GPI设备管理器
    /// </summary>
    public static class GPIManager
    {
        /// <summary>
        /// 设备个数
        /// </summary>
        public static int DevCount { get; private set; }

        /// <summary>
        /// 设备句柄
        /// </summary>
        public static IntPtr[] DevHandles { get; private set; } = new IntPtr[20];

        /// <summary>
        /// 初始化设备
        /// </summary>
        public static void Initialize()
        {
            DevCount = GPI_USB_DEVICE.USB_ScanDevice(DevHandles);
        }

        /// <summary>
        /// 打开设备
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <returns>执行结果 true:成功，false：失败</returns>
        public static bool OpenDevice(IntPtr DevHandle)
        {
            bool state = GPI_USB_DEVICE.USB_OpenDevice(DevHandle);
            if (!state)
            {
                Console.WriteLine("Open device error!" + DevHandle.ToString("X8"));
            }
            else
            {
                //初始化输入 IN0~IN3
                GPI_USB2GPI_DEVICE.GPIO_SetInput(DevHandle, 0x03C0, 0);
            }
            return state;
        }
    }
}
