﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 系统监视解释器 -- CPU
    /// </summary>
    public class SystemMonitorProvider_CPU : IMonitorProvider
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name => "CPU";

        /// <summary>
        /// CPU性能计数组件
        /// </summary>
        private PerformanceCounter cpuCounter = new PerformanceCounter("Processor", "% Processor Time", "_Total");

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="info">监控信息</param>
        public void Execute(MonitorInfolBase info)
        {
            SystemMonitorInfo system = info as SystemMonitorInfo;

            system.CpuUsedPercentage = this.cpuCounter.NextValue() / 100f;
        }
    }
}
