﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TDx.SpaceMouse.Navigation3D;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 3D鼠标摄像机
    /// </summary>
    public class Navigation3DCamera
    {
        /// <summary>
        /// 位置矩阵
        /// </summary>
        public Matrix Matrix { get; internal set; } = new Matrix(1, 0, 0, 0,
                                                                 0, 1, 0, 0,
                                                                 0, 0, 1, 0,
                                                                 0, 0, 30, 1);

        /// <summary>
        /// 上方向
        /// </summary>
        public Vector UpDirection { get; internal set; } = new Vector(0, 1, 0);

        /// <summary>
        /// 面向
        /// </summary>
        public Vector LookDirection { get; internal set; } = new Vector(0, 0, -1);

        /// <summary>
        /// 位置
        /// </summary>
        public Point Position { get; internal set; } = new Point(0, 0, 30);
    }
}
