﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TDx.SpaceMouse.Navigation3D;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 3D鼠标模型
    /// </summary>
    public partial class Navigation3DModel
    {
        /// <summary>
        /// 3D鼠标模型
        /// </summary>
        public Navigation3DModel()
        {
            this.Smooth.Init(0);
        }

        /// <summary>
        /// 摄像机
        /// </summary>
        public Navigation3DCamera Camera { get; private set; } = new Navigation3DCamera();

        /// <summary>
        /// 调匀摄像机
        /// </summary>
        public Navigation3DCamera SmoothCamera { get; private set; } = new Navigation3DCamera();

        /// <summary>
        /// 摄像机X轴最大值
        /// </summary>
        public double MaxX { get; set; } = 3;

        /// <summary>
        /// 是否使用平滑
        /// </summary>
        public bool IsUseSmooth { get; set; } = true;

        /// <summary>
        /// 是否准备完毕
        /// </summary>
        public bool IsReady { get; set; } = true;

        /// <summary>
        /// 平滑处理器
        /// </summary>
        private Navigation3DSmooth Smooth = new Navigation3DSmooth();

        /// <summary>
        /// 更新调匀值
        /// </summary>
        public void UpdateSmooth()
        {
            double x = -this.Camera.Position.X;
            if (this.IsUseSmooth)
            {
                x = this.Smooth.Call(-this.Camera.Position.X);
            }

            x = MathHelper.Clip(-this.MaxX, this.MaxX, x);

            this.SmoothCamera.Position = new Point(x, 0, 0);
        }

        /// <summary>
        /// 重置X值
        /// </summary>
        /// <param name="x">X坐标</param>
        public void Reset(double x)
        {
            this.Camera.Position = new Point(-x, 0, 0);
            this.Camera.Matrix = new Matrix(1, 0, 0, 0,
                                            0, 1, 0, 0,
                                            0, 0, 1, 0,
                                            -x, 0, 30, 1);

            this.Smooth.Init(x);
        }
    }
}
