﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Module
{
    /// <summary>
    /// 应用程序启动基类
    /// </summary>
    public abstract class AppSetupBase : IAppSetup
    {
        /// <summary>
        /// 描述
        /// </summary>
        public abstract string Detail { get; }

        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled { get; set; } = true;

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public abstract bool Setup(AppSetupContext context);

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public abstract void Shutdown(AppSetupContext context);
    }
}
