﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Connection
{
    /// <summary>
    /// 连接消息基类
    /// </summary>
    public abstract class ConnMessageBase
    {
        /// <summary>
        /// 本地IP
        /// </summary>
        public string LocalIP { get; internal set; }

        /// <summary>
        /// 本地端口
        /// </summary>
        public int LocalPort { get; internal set; }

        /// <summary>
        /// 远程IP
        /// </summary>
        public string RemoteIP { get; internal set; }

        /// <summary>
        /// 远程端口
        /// </summary>
        public int RemotePort { get; internal set; }

        /// <summary>
        /// 串口名称
        /// </summary>
        public string PortName { get; internal set; }

        /// <summary>
        /// 处理器
        /// </summary>
        public IConnPackageProvider Provider { get; internal set; }
    }
}
