﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Module;
using log4net;

namespace VIZ.Framework.UDPTestTool
{
    /// <summary>
    /// 应用程序启动 -- 初始化Excel
    /// </summary>
    public class AppSetup_InitExcel : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitExcel));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化Excel";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "config", "udp_info.xls");

            ApplicationDomainEx.ExcelContext.LoadUdpSignalInfos(path);

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {

        }
    }
}
