﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Common;
using VIZ.Framework.Core;

namespace VIZ.Framework.WpfTest
{
    /// <summary>
    /// OpenCVVideoTest.xaml 的交互逻辑
    /// </summary>
    public partial class OpenCVVideoTest : UserControl
    {
        public OpenCVVideoTest()
        {
            InitializeComponent();
        }

        private void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            // 附加插件
            TrackingBoxPlugin trackingBoxPlugin = new TrackingBoxPlugin(this.video);
            trackingBoxPlugin.TrackingBoxClick += TrackingBoxPlugin_TrackingBoxClick;

            SelectionBoxPlugin selectionBoxPlugin = new SelectionBoxPlugin(this.video);
            selectionBoxPlugin.Selected += SelectionBoxPlugin_Selected;

            ClipBoxPlugin clipBoxPlugin = new ClipBoxPlugin(this.video);

            this.video.AttachPlugin(trackingBoxPlugin);
            this.video.AttachPlugin(selectionBoxPlugin);
            this.video.AttachPlugin(clipBoxPlugin);

            // 接入OpenCV插件
            OpenCVStreamOption option = new OpenCVStreamOption();
            OpenCVStream stream = new OpenCVStream(option);
            stream.ExecuteVideoFrame += Stream_ExecuteVideoFrame;
            stream.ChangeUri(@"E:\视频\1.mp4");
            stream.Play();

            // 更新矩形框信息
            List<TrackingBoxInfo> list = new List<TrackingBoxInfo>();
            list.Add(new TrackingBoxInfo
            {
                DrawingBorderColor = SharpDxColorHelper.FromString("#FFFF0000"),
                ID = "1",
                DrawingBorderWidth = 4,
                SrcRect = new SharpDX.Mathematics.Interop.RawRectangleF(0, 0, 200, 120)
            });
            list.Add(new TrackingBoxInfo
            {
                DrawingBorderColor = SharpDxColorHelper.FromString("#FFFF0000"),
                ID = "1",
                DrawingBorderWidth = 4,
                SrcRect = new SharpDX.Mathematics.Interop.RawRectangleF(400, 300, 600, 420)
            });
            this.video.UpdateTrackingBox(list);

            // 裁剪
            ClipBoxInfo clipBoxInfo = new ClipBoxInfo();
            clipBoxInfo.DrawingBorderWidth = 8;
            clipBoxInfo.DrawingBorderColor = SharpDxColorHelper.FromString("#AA0000FF");
            clipBoxInfo.MaskColor = SharpDxColorHelper.FromString("#66000000");
            clipBoxInfo.SrcRect = new SharpDX.Mathematics.Interop.RawRectangleF(200, 0, 800, 1080);

            this.video.UpdateClipBox(clipBoxInfo);
        }

        private void Stream_ExecuteVideoFrame(object sender, VideoFrameEventArgs e)
        {
            this.video.UpdateVideoFrame(e.Frame);
        }

        private void SelectionBoxPlugin_Selected(object sender, SelectionBoxSelectedEventArgs e)
        {
            Rect rect = e.DrawingRect.ToRect();
            Debug.WriteLine($"Slect: [{rect.X}, {rect.Y}, {rect.Width}, {rect.Height}]");
        }

        private void TrackingBoxPlugin_TrackingBoxClick(object sender, TrackingBoxClickEventArgs e)
        {
            TrackingBoxInfo info = e.HitTrackingBoxInfos.FirstOrDefault();
            if (info == null)
                return;

            Rect rect = info.SrcRect.ToRect();
            Debug.WriteLine($"Click: [{rect.X}, {rect.Y}, {rect.Width}, {rect.Height}]");
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            OpenCvSharp.Mat mat = this.video.RenderVideoToMat(new List<string>
            {
                VideoControlPluginNames.TrackingBox,
                VideoControlPluginNames.SelectionBox,
                VideoControlPluginNames.ClipBox
            });

            mat.SaveImage(@"e:\1.jpg");

            mat.Dispose();
        }

        private void Button_Click2(object sender, RoutedEventArgs e)
        {
            this.video.ClearClipBox();
        }
    }
}
