﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Common
{
    /// <summary>
    /// 视频流管理器
    /// </summary>
    public static class VideoStreamManager
    {
        /// <summary>
        /// 池
        /// </summary>
        private static Dictionary<string, IVideoStream> pool = new Dictionary<string, IVideoStream>();

        /// <summary>
        /// 添加视频流工具
        /// </summary>
        /// <param name="key">建</param>
        /// <param name="stream">视频流</param>
        public static void Append(string key, IVideoStream stream)
        {
            lock (pool)
            {
                if (pool.ContainsKey(key))
                    throw new Exception($"key: {key}, is already exists");

                pool[key] = stream;
            }
        }

        /// <summary>
        /// 获取视频流
        /// </summary>
        /// <typeparam name="T">视频流类型</typeparam>
        /// <param name="key">键</param>
        /// <returns>视频流</returns>
        public static T Get<T>(string key) where T : class, IVideoStream
        {
            pool.TryGetValue(key, out IVideoStream stream);
            return stream as T;
        }

        /// <summary>
        /// 移除视频流
        /// </summary>
        /// <param name="key">键</param>
        public static void Remove(string key)
        {
            lock (pool)
            {
                if (pool.ContainsKey(key))
                {
                    pool.Remove(key);
                }
            }
        }

        /// <summary>
        /// 清理所有视频流
        /// </summary>
        public static void Clear()
        {
            lock (pool)
            {
                pool.Clear();
            }
        }
    }
}
