﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Connection
{
    /// <summary>
    /// 链接管理器
    /// </summary>
    public static class ConnectionManager
    {
        /// <summary>
        /// Udp连接
        /// </summary>
        public static UdpConnection UdpConnection { get; set; }

        /// <summary>
        /// TCP连接
        /// </summary>
        public static TcpConnection TcpConnection { get; set; }

        /// <summary>
        /// 串口连接
        /// </summary>
        public static SerialPortConnection SerialPortConnection { get; set; }

        /// <summary>
        /// TCP连接监听器
        /// </summary>
        public static Dictionary<string, TcpConnectionListener> TcpConnectionListeners { get; private set; } = new Dictionary<string, TcpConnectionListener>();
    }
}
