﻿using Microsoft.VisualBasic.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// 对象池管理器
    /// </summary>
    public interface IObjectPoolManager
    {
        /// <summary>
        /// 添加对象
        /// </summary>
        /// <param name="key">键</param>
        /// <param name="obj">对象</param>
        /// <returns>是否成功添加</returns>
        bool Add(string key, object obj);

        /// <summary>
        /// 销毁
        /// </summary>
        /// <param name="key">键</param>
        /// <returns>是否成功销毁</returns>
        bool Dispose(string key);

        /// <summary>
        /// 销毁所有的对象
        /// </summary>
        void DisposeAll();
    }
}
