﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Framework.Core
{
    /// <summary>
    /// USB设备
    /// </summary>
    public static class USBDevice
    {
        /// <summary>
        /// 扫描查找设备
        /// </summary>
        /// <param name="pDevHandle">设备句柄</param>
        /// <remarks>pDevHandle数组长度一般为20</remarks>
        /// <returns>函数执行状态，小于0函数执行出错</returns>
        [DllImport("LUCERO.dll")]
        public static extern Int32 USB_ScanDevice(Int32[] pDevHandle);

        /// <summary>
        /// 打开设备
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <returns>设备状态，是否可用</returns>
        [DllImport("LUCERO.dll")]
        public static extern bool USB_OpenDevice(Int32 DevHandle);

        /// <summary>
        /// 关闭设备
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <returns>是否成功关闭</returns>
        [DllImport("LUCERO.dll")]
        public static extern bool USB_CloseDevice(Int32 DevHandle);

        /// <summary>
        /// 获取设备信息
        /// </summary>
        /// <param name="DevHandle">设备句柄</param>
        /// <param name="pDevInfo">设备信息</param>
        /// <param name="pFunctionStr">功能字符串</param>
        /// <returns>是否成功获取</returns>
        [DllImport("LUCERO.dll")]
        public static extern bool DEV_GetDeviceInfo(Int32 DevHandle, ref USBDeviceStruct pDevInfo, StringBuilder pFunctionStr);
    }
}
